```
M   M  AA  III DDD   SSS  
MM MM A  A  I  D  D S     
M M M AAAA  I  D  D  SSS  
M   M A  A  I  D  D     S
M   M A  A III DDD  SSSS

By Doctor Eli Selig and Kurumi
```
## MAIDS

Maids is the Science Foundation programming language.
MAIDS is CC0.

## Requirements

- Java 23
- `javac`, `jar`, and `java` command-line tools
- Preview features must be available for unnamed variables

## Building from Source

### Installers

```bash
install.sh
```

Or on Windows:

```cmd
install.bat
```

This will install MAIDS. You will need to add the bin directory to the PATH.

## Project Structure

```
.
âââ Main.java                           # Entry point and CLI
âââ compiler/
â   âââ CompilerForMAIDS.java          # Compiles MAIDS source to executable form
âââ machine/
â   âââ VirtualMachine.java            # Executes compiled programs
â   âââ processor/
â   â   âââ ProcessorForMAIDS.java     # Core evaluation engine
â   â   âââ DummyProcessor.java        # Test stub
â   â   âââ builtins/
â   â   â   âââ Builtins.java          # Built-in functions (string, math, I/O)
â   â   âââ spec/
â   â       âââ Processor.java         # Processor interface
â   âââ record/
â   â   âââ Record.java                # Base record type
â   â   âââ Pending.java               # Pending computation
â   â   âââ Success.java               # Successful output
â   â   âââ Failure.java               # Failed branch
â   âââ utils/
â       âââ Utilities.java             # Helper functions
âââ matcher/
â   âââ Matcher.java                   # Pattern matching utilities
âââ parser/
    âââ CombinatorsForMAIDS.java       # Parser combinators for MAIDS syntax
    âââ ConsumerForMAIDS.java          # Consumes matched input
    âââ HighOrderCombinators.java      # Reusable parser building blocks
    âââ MAID/
        âââ MAIDCombinators.java       # Core parsing abstractions
```

## Learning MAIDS

For detailed information about the MAIDS language, syntax, and features, please refer to the MAIDS manual (available separately).


