package compiler;

import compiler.passes.*;
import compiler.spec.Pass;

public class CompilerForMAIDS {
    public static String compile(String maidCode) {
        maidCode = compile(maidCode,
                new RemoveComments(),
                new Validator(),
                new NumberAppender(),
                new NameExpander(),
                new NumberExpander(),
                new AnonymousExpander(),
                new QuestionExpander(),
                new StringReducer(),
                new Cleaner()
        );
        return maidCode;
    }


    private static String compile(String maidCode, Pass... passes) {
        for (Pass pass : passes)
            maidCode = pass.pass(maidCode);
        return maidCode;
    }
}




