package compiler.passes;

import compiler.spec.Pass;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import static machine.utils.Utilities.randomAlphaNumeric;
import static parser.CombinatorsForMAIDS.*;

public class AnonymousExpander extends Pass {

    public AnonymousExpander() {
        super("Anonymous Expander");
    }

    public String pass(String input) {
        var lineCount = Matcher.count(parser("validate"), input);
        for (int lineNumber = 0; lineNumber < lineCount; lineNumber++) {
            var line = ((Matcher.SuccessfulMatch) Matcher.get(parser("validate"), input, lineNumber)).match();
            var hitCount = Matcher.count(parser("numberless_anonymous"), line);
            for (int hitNumber = 0; hitNumber < hitCount; hitNumber++) {
                var hit = ((Matcher.SuccessfulMatch) Matcher.get(parser("numberless_anonymous"), line, hitNumber)).match();
                var fullAnonContents = parser("anonymous_with_arguments_and_parameters").transform(new MAIDCombinators.State(hit));
                if (fullAnonContents instanceof MAIDCombinators.Success) {
                    var anonContent = ((MAIDCombinators.Success) fullAnonContents).result();
                    var parameters = ((MAIDCombinators.Success) parser("parameters_from_arguments_and_parameters").transform(new MAIDCombinators.State(anonContent))).result();
                    var arguments = ((MAIDCombinators.Success) parser("arguments_from_arguments_and_parameters").transform(new MAIDCombinators.State(anonContent))).result();
                    var name = randomAlphaNumeric(10);
                    var ruleFromAnonContent = ((MAIDCombinators.Success) parser("rule_from_content", Matcher.concatenate(name, parameters)).transform(new MAIDCombinators.State(anonContent))).result();
                    line = Matcher.replace(parser("numberless_anonymous"), line, Matcher.concatenate(" ", Matcher.concatenate(Matcher.concatenate(name, arguments), " ")), hitNumber);
                    return pass(Matcher.replace(parser("validate"), input, Matcher.concatenate(Matcher.concatenate(ruleFromAnonContent, "\n"), line), lineNumber));
                }
                fullAnonContents = parser("anonymous_without_arguments_and_parameters").transform(new MAIDCombinators.State(hit));
                if (fullAnonContents instanceof MAIDCombinators.Success) {
                    var anonContent = ((MAIDCombinators.Success) fullAnonContents).result();
                    var name = randomAlphaNumeric(10);
                    var ruleFromAnonContent = Matcher.concatenate(((MAIDCombinators.Success) parser("rule_from_content", name).transform(new MAIDCombinators.State(anonContent))).result(), "\n");
                    line = Matcher.replace(parser("numberless_anonymous"), line, Matcher.concatenate(" ", Matcher.concatenate(name, " ")), hitNumber);
                    return pass(Matcher.replace(parser("validate"), input, Matcher.concatenate(ruleFromAnonContent, line), lineNumber));
                }
            }
        }
        return input;
    }

}

