package compiler.passes;

import compiler.spec.Pass;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.*;
import static parser.HighOrderCombinators.*;
import static parser.HighOrderCombinators.any;
import static parser.MAID.MAIDCombinators.A;

public class Cleaner extends Pass {
    public Cleaner() {
        super("Cleaner");
    }

    public String pass(String input) {
        return Matcher.rewrite(whitespaceRemover(), input);
    }

    private static MAIDCombinators whitespaceRemover() {
        return zeroOrMore(A(
                seq(string, apply(oneOrMore(any(whitespaceCharacters)), _ -> ""), identifier),
                string,
                seq(identifier, apply(oneOrMore(any(whitespaceCharacters)), _ -> ""), string),
                apply(literal("\n"), _ -> ""),
                seq(comma, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(assignment, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(pipe, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(oParen, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(cParen, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(oBrace, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(cBrace, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(oBracket, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(cBracket, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(semicolon, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(star, silent(oneOrMore(any(whitespaceCharacters)))),
                seq(silent(oneOrMore(any(whitespaceCharacters))), comma),
                seq(silent(oneOrMore(any(whitespaceCharacters))), assignment),
                seq(silent(oneOrMore(any(whitespaceCharacters))), pipe),
                seq(silent(oneOrMore(any(whitespaceCharacters))), oParen),
                seq(silent(oneOrMore(any(whitespaceCharacters))), cParen),
                seq(silent(oneOrMore(any(whitespaceCharacters))), oBrace),
                seq(silent(oneOrMore(any(whitespaceCharacters))), cBrace),
                seq(silent(oneOrMore(any(whitespaceCharacters))), oBracket),
                seq(silent(oneOrMore(any(whitespaceCharacters))), cBracket),
                seq(silent(oneOrMore(any(whitespaceCharacters))), semicolon),
                seq(silent(oneOrMore(any(whitespaceCharacters))), star),
                apply(oneOrMore(any(whitespaceCharacters)), _ -> " "),
                any()));
    }
}
