package compiler.passes;

import compiler.spec.Pass;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.*;

public class NameExpander extends Pass {

    public NameExpander() {
        super("Name Expander");
    }

    @Override
    public String pass(String input) {
        if(Matcher.contains(parser("multiple_names"), input)){
            var line = ((Matcher.SuccessfulMatch) Matcher.get(parser("multiple_names"), input, 0)).match();
            var first = ((MAIDCombinators.Success) parser("first_name")
                    .transform(line)).result();
            var rest = ((MAIDCombinators.Success) parser("remaining_names")
                    .transform(line)).result();
            return pass(Matcher.replace(parser("multiple_names"), input, Matcher.concatenate(first, rest), 0));
        }
        return input;
    }
}

