package compiler.passes;

import compiler.spec.Pass;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.parser;
import static parser.HighOrderCombinators.oneOrMore;

public class NumberAppender extends Pass {

    public NumberAppender() {
        super("Number Appender");
    }

    public String pass(String input) {
        var res = oneOrMore(parser("append_numbers"))
                .transform(new MAIDCombinators.State(input));
        if (res instanceof MAIDCombinators.Success)
            return ((MAIDCombinators.Success) res).result();
        throw new RuntimeException("Number Appender Failed.");
    }
}

