package compiler.passes;

import compiler.spec.Pass;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.parser;
import static parser.HighOrderCombinators.repeat;
import static parser.MAID.MAIDCombinators.I;

public class NumberExpander extends Pass {

    public NumberExpander() {
        super("Number Expander");
    }

    public String pass(String input) {
        input = expandAlternationNumbers(input);
        input = expandAnonymousNumbers(input);
        return input;
    }

    private static String expandAlternationNumbers(String input) {
        if (Matcher.count(parser("numbered_line"), input) > 0) {
            var line = ((Matcher.SuccessfulMatch) Matcher.get(parser("numbered_line"), input, 0)).match();
            var items = Matcher.concatenate("| ", ((MAIDCombinators.Success) parser("alternation_from_line").transform(new MAIDCombinators.State(line))).result());
            var itemCount = Matcher.count(parser("item"), items);
            var expandedItems = "";
            for (int itemNumber = 0; itemNumber < itemCount; itemNumber++) {
                var item = ((Matcher.SuccessfulMatch) Matcher.get(parser("item"), items, itemNumber)).match();
                var itemQuantity = Integer.parseInt(((Matcher.SuccessfulMatch) Matcher.get(parser("quantity"), items, itemNumber)).match());
                var itemContent = ((MAIDCombinators.Success) parser("content").transform(new MAIDCombinators.State(item))).result();
                var expanded = ((MAIDCombinators.Success) repeat(I(itemContent), itemQuantity, " | ").transform(new MAIDCombinators.State(itemContent))).result();
                if (itemNumber < itemCount - 1)
                    expandedItems = Matcher.concatenate(Matcher.concatenate(expandedItems, expanded), " | ");
                else
                    expandedItems = Matcher.concatenate(expandedItems, expanded);
            }
            var newLine = Matcher.concatenate(Matcher.concatenate(((MAIDCombinators.Success) parser("name_and_assignment").transform(new MAIDCombinators.State(line))).result(), expandedItems), " ;\n");
            return expandAlternationNumbers(Matcher.replace(parser("numbered_line"), input, newLine, 0));
        }
        return input;
    }

    private static String expandAnonymousNumbers(String input) {
        var stringOrAnonymousCount = Matcher.count(parser("string_or_anonymous"), input);
        for (int stringOrAnonymousIndex = 0; stringOrAnonymousIndex < stringOrAnonymousCount; stringOrAnonymousIndex++) {
            var stringOrAnonymous = ((Matcher.SuccessfulMatch) Matcher.get(parser("string_or_anonymous"), input, stringOrAnonymousIndex)).match();
            var anonymous = parser("anonymous").transform(new MAIDCombinators.State(stringOrAnonymous));
            if (anonymous instanceof MAIDCombinators.Success) {
                var items = Matcher.concatenate("| ", ((MAIDCombinators.Success) parser("alternation_from_anonymous").transform(new MAIDCombinators.State(((MAIDCombinators.Success) anonymous).result()))).result());
                var itemCount = Matcher.count(parser("item"), items);
                var expandedItems = "";
                for (int itemNumber = 0; itemNumber < itemCount; itemNumber++) {
                    var item = ((Matcher.SuccessfulMatch) Matcher.get(parser("item"), items, itemNumber)).match();
                    var itemQuantity = Integer.parseInt(((Matcher.SuccessfulMatch) Matcher.get(parser("quantity"), items, itemNumber)).match());
                    var itemContent = ((MAIDCombinators.Success) parser("content").transform(new MAIDCombinators.State(item))).result();
                    var expanded = ((MAIDCombinators.Success) repeat(I(itemContent), itemQuantity, " | ").transform(new MAIDCombinators.State(itemContent))).result();
                    if (itemNumber < itemCount - 1)
                        expandedItems = Matcher.concatenate(Matcher.concatenate(expandedItems, expanded), " | ");
                    else
                        expandedItems = Matcher.concatenate(expandedItems, expanded);
                }
                var newAnonymous = ((MAIDCombinators.Success) parser("anonymous_assignment", expandedItems).transform(new MAIDCombinators.State(stringOrAnonymous))).result();
                return expandAnonymousNumbers(Matcher.replace(parser("string_or_anonymous"), input, newAnonymous, stringOrAnonymousIndex));
            }
        }
        return input;
    }
}
