package compiler.passes;

import compiler.spec.Pass;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import static machine.utils.Utilities.randomAlphaNumeric;
import static parser.CombinatorsForMAIDS.*;

public class QuestionExpander extends Pass {
    public QuestionExpander() {
        super("Question Expander");
    }

    public String pass(String input) {
        var lineCount = Matcher.count(parser("validate"), input);
        for (int lineNumber = 0; lineNumber < lineCount; lineNumber++) {
            var line = ((Matcher.SuccessfulMatch) Matcher.get(parser("validate"), input, lineNumber)).match();
            var hitCount = Matcher.count(parser("predicate"), line);
            if (hitCount > 0) {
                var hit = ((Matcher.SuccessfulMatch) Matcher.get(parser("predicate"), line, 0)).match();
                var baseName = randomAlphaNumeric(10);
                var trueName = Matcher.concatenate("T", baseName);
                var falseName = Matcher.concatenate("F", baseName);
                var trueBranch = ((MAIDCombinators.Success) parser("true_branch", trueName).transform(new MAIDCombinators.State(hit))).result();
                var falseBranch = ((MAIDCombinators.Success) parser("false_branch", falseName).transform(new MAIDCombinators.State(hit))).result();
                var newIndirection = ((MAIDCombinators.Success) parser("indirection_from_question", baseName).transform(new MAIDCombinators.State(hit))).result();
                line = Matcher.replace(parser("predicate"), line, newIndirection, 0);
                line = Matcher.concatenate(Matcher.concatenate(trueBranch, falseBranch), line);
                return Matcher.replace(parser("validate"), input, line, lineNumber);
            }
        }
        return input;
    }
}

