package compiler.passes;

import compiler.spec.Pass;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.*;
import static parser.HighOrderCombinators.*;
import static parser.MAID.MAIDCombinators.A;

public class RemoveComments extends Pass {
    private static final MAIDCombinators startMultiLineComment = literal("/*");
    private static final MAIDCombinators endMultiLineComment = literal("*/");
    private static final MAIDCombinators startSingleLineComment = literal("//");

    public RemoveComments() {
        super("Comment Remover");
    }

    public String pass(String input) {
        var res = commentRemover().transform(input);
        if (res instanceof MAIDCombinators.Success)
            return ((MAIDCombinators.Success) res).result();
        throw new RuntimeException("Failed to remove comments");
    }

    private static MAIDCombinators commentRemover() {
        return zeroOrMore(A(string, apply(multiLineComment(), _ -> ""), apply(singleLineComment(), _ -> "\n"), any()));
    }

    private static MAIDCombinators multiLineComment() {
        var multiLine = new MAIDCombinators.FixedPoint();
        multiLine.set(A(endMultiLineComment, seq(any(), multiLine)));
        return seq(startMultiLineComment, multiLine);
    }

    private static MAIDCombinators singleLineComment() {
        var singleLine = new MAIDCombinators.FixedPoint();
        singleLine.set(A(literal("\n"), seq(any(), singleLine)));
        return seq(startSingleLineComment, singleLine);
    }
}
