package compiler.passes;

import compiler.spec.Pass;
import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.parser;
import static parser.HighOrderCombinators.oneOrMore;

public class Validator extends Pass {
    public Validator() {
        super("Validator");
    }

    public String pass(String input) {
        var res = oneOrMore(parser("validate")).transform(new MAIDCombinators.State(input));
        if (res instanceof MAIDCombinators.Success)
            if (((MAIDCombinators.Success) res).result().length() == ((MAIDCombinators.Success) res).state().input().length())
                return ((MAIDCombinators.Success) res).result();
        throw new RuntimeException("Validation failed");
    }
}

