@echo off
setlocal enabledelayedexpansion

echo === MAIDS Installation Script ===
echo.

REM Check for Java
where java >nul 2>nul
if %errorlevel% neq 0 (
    echo Error: Java is not installed or not in PATH
    exit /b 1
)

where javac >nul 2>nul
if %errorlevel% neq 0 (
    echo Error: javac is not installed or not in PATH
    exit /b 1
)

REM Check Java version
for /f "tokens=3" %%i in ('java -version 2^>^&1 ^| findstr /I "version"') do (
    set JAVA_VERSION=%%i
)
set JAVA_VERSION=%JAVA_VERSION:"=%
for /f "tokens=1 delims=." %%i in ("%JAVA_VERSION%") do set JAVA_MAJOR=%%i

if %JAVA_MAJOR% LSS 21 (
    echo Error: Java 21 or later is required ^(found Java %JAVA_MAJOR%^)
    exit /b 1
)

echo [32mOK[0m Java %JAVA_MAJOR% detected
echo.

REM Compile
echo Compiling MAIDS...
dir /s /B *.java > sources.txt
javac --enable-preview --release 23 @sources.txt
if %errorlevel% neq 0 (
    echo Error: Compilation failed
    del sources.txt
    exit /b 1
)
del sources.txt
echo [32mOK[0m Compilation successful
echo.

REM Create JAR
echo Creating maids.jar...
jar cfe maids.jar Main -C . .
if %errorlevel% neq 0 (
    echo Error: JAR creation failed
    exit /b 1
)
echo [32mOK[0m JAR created successfully
echo.

REM Determine installation directory
set "INSTALL_DIR=C:\maids"

REM Create installation directory structure
if not exist "%INSTALL_DIR%\" mkdir "%INSTALL_DIR%"
if not exist "%INSTALL_DIR%\bin\" mkdir "%INSTALL_DIR%\bin"
echo Installing to %INSTALL_DIR%
echo.

REM Move JAR to installation directory
set "JAR_PATH=%INSTALL_DIR%\maids.jar"
echo Moving maids.jar to %JAR_PATH%...
move /Y maids.jar "%JAR_PATH%" >nul
if %errorlevel% neq 0 (
    echo Error: Failed to move JAR to installation directory
    exit /b 1
)
echo [32mOK[0m JAR installed
echo.

REM Create batch wrapper
set "WRAPPER_SCRIPT=%INSTALL_DIR%\bin\maids.bat"
echo Creating wrapper script at %WRAPPER_SCRIPT%...

echo @echo off> "%WRAPPER_SCRIPT%"
echo java --enable-preview -jar "%%~dp0..\maids.jar" %%*>> "%WRAPPER_SCRIPT%"

echo [32mOK[0m Wrapper script created
echo.

echo === Installation Complete ===
echo.
echo Installation directory: %INSTALL_DIR%
echo JAR location: %JAR_PATH%
echo Wrapper script: %WRAPPER_SCRIPT%
echo.

REM Check if install directory is in PATH
echo %PATH% | findstr /I /C:"%INSTALL_DIR%\bin" >nul
if %errorlevel% neq 0 (
    echo [33mIMPORTANT:[0m %INSTALL_DIR%\bin is not in your PATH
    echo.
    echo To add it permanently, run this command as Administrator:
    echo   setx PATH "%%PATH%%;%INSTALL_DIR%\bin"
    echo.
    echo Or add it manually through System Properties ^> Environment Variables
    echo.
    echo After adding to PATH, restart your command prompt and run:
    echo   maids -i your-program.maids
) else (
    echo [32mOK[0m '%INSTALL_DIR%\bin' is already in your PATH
    echo.
    echo Try running:
    echo   maids -i your-program.maids
)

endlocal

