package machine.utils;

import machine.record.Pending;
import machine.record.Record;
import machine.record.Success;
import matcher.Matcher;
import parser.MAID.MAIDCombinators;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static parser.CombinatorsForMAIDS.*;
import static parser.CombinatorsForMAIDS.alphanumeric;


public class Utilities {

    public static List<String> getParameterList(String input) {
        var parameterList = new ArrayList<String>();
        var transformed = parser("parameters_from_statement").transform(new MAIDCombinators.State(input));
        if (transformed instanceof MAIDCombinators.Success s) {
            var parameters = s.result();
            var parameterCount = Matcher.count(parser("local"), parameters);
            for (int i = 0; i < parameterCount; i++) {
                parameterList.add(((Matcher.SuccessfulMatch) Matcher.get(parser("local"), parameters, i)).match());
            }
        }
        return parameterList;
    }

    public static List<String> getArgumentList(String input) {
        var argumentList = new ArrayList<String>();
        var arguments = (((MAIDCombinators.Success) parser("arguments_from_identifier_with_arguments").transform(new MAIDCombinators.State(input)))).result();
        var argumentCount = Matcher.count(parser("item"), arguments);
        for (int i = 0; i < argumentCount; i++)
            argumentList.add(((Matcher.SuccessfulMatch) Matcher.get(parser("content"), arguments, i)).match());
        return argumentList;
    }

    public static List<String> getAlternationContentsByName(String input, String name) {
        var alternationList = new ArrayList<String>();
        var line = ((Matcher.SuccessfulMatch) Matcher.get(parser("statement_by_name", name), input, 0)).match();
        var alternation = Matcher.concatenate("|", ((Matcher.SuccessfulMatch) Matcher.get(parser("alternation_from_line"), line, 0)).match());
        var itemCount = Matcher.count(parser("item_from_statement"), alternation);
        for (int itemNumber = 0; itemNumber < itemCount; itemNumber++) {
            var content = ((Matcher.SuccessfulMatch) Matcher.get(parser("item_from_statement"), alternation, itemNumber)).match();
            alternationList.add(content);
        }
        return alternationList;
    }

    public static String randomAlphaNumeric(int length) {
        if (length < 1)
            throw new IllegalArgumentException("length must be â¥ 1");
        SecureRandom RNG = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        sb.append(alpha.charAt(RNG.nextInt(alpha.length())));
        for (int i = 1; i < length; i++)
            sb.append(alphanumeric.charAt(RNG.nextInt(alphanumeric.length())));
        return sb.toString();
    }

    public static String processArgumentsAndParameters(String content, Map<String, String> parameterToArgumentMap) {
        var hitCount = Matcher.count(parser("string_or_local"), content);
        for (int i = 0; i < hitCount; i++) {
            var hitContent = ((Matcher.SuccessfulMatch)Matcher.get(parser("string_or_local"), content, i)).match();
            var local = parser("local").transform(new MAIDCombinators.State(hitContent));
            if (local instanceof MAIDCombinators.Success) {
                var localValue = ((MAIDCombinators.Success) local).result();
                return processArgumentsAndParameters(Matcher.replace(parser("string_or_local"), content, parameterToArgumentMap.get(localValue), i), parameterToArgumentMap);
            }
        }
        return content;
    }

    public static Map<String, String> makeParameterToArgumentMap(List<String> parameterList, List<String> argumentList) {
        var parameterToArgumentMap = new HashMap<String, String>();
        for (int i = 0; i < parameterList.size(); i++)
            parameterToArgumentMap.put(parameterList.get(i), argumentList.get(i));
        return parameterToArgumentMap;
    }

    public static List<String> getAlternationContentsFromStatement(String statement) {
        var alternationList = new ArrayList<String>();
        var alternation = Matcher.concatenate("|", ((Matcher.SuccessfulMatch) Matcher.get(parser("alternation_from_line"), statement, 0)).match());
        var itemCount = Matcher.count(parser("item_from_statement"), alternation);
        for (int i = 0; i < itemCount; i++) {
            var content = ((Matcher.SuccessfulMatch) Matcher.get(parser("item_from_statement"), alternation, i)).match();
            alternationList.add(content);
        }
        return alternationList;
    }

    // Remove all statements with the given name from the environment (program text).
    public static String deleteStatementsByName(String input, String name) {
        String updated = input;
        int count = Matcher.count(parser("statement_by_name", name), updated);
        while (count > 0) {
            updated = Matcher.replace(parser("statement_by_name", name), updated, "", 0);
            count = Matcher.count(parser("statement_by_name", name), updated);
        }
        return updated;
    }

    // Cartesian product of a list of lists; returns list of argument tuples.
    public static List<List<String>> cartesianProduct(List<List<String>> lists) {
        var result = new ArrayList<List<String>>();
        result.add(new ArrayList<>());
        for (var list : lists) {
            var next = new ArrayList<List<String>>();
            for (var prefix : result) {
                for (var item : list) {
                    var tuple = new ArrayList<String>(prefix.size() + 1);
                    tuple.addAll(prefix);
                    tuple.add(item);
                    next.add(tuple);
                }
            }
            result = next;
        }
        return result;
    }

}

