package parser;

import parser.MAID.MAIDCombinators;

import static parser.CombinatorsForMAIDS.*;
import static parser.HighOrderCombinators.*;
import static parser.HighOrderCombinators.any;
import static parser.HighOrderCombinators.optional;
import static parser.HighOrderCombinators.seq;
import static parser.HighOrderCombinators.silent;
import static parser.HighOrderCombinators.zeroOrMore;
import static parser.MAID.MAIDCombinators.A;

public class ConsumerForMAIDS {
    public static MAIDCombinators consume(String type) {
        var local = seq(untrimmedToken(star), untrimmedToken(identifier));
        var concatenate = untrimmedToken(A(mutation, indirect, direct, string));
        var concatenates = oneOrMore(concatenate);
        parameters.set(seq(oParen, local, zeroOrMore(seq(comma, local)), cParen));
        deletion.set(seq(oBracket, exclamation, identifier, cBracket));
        mutation.set(A(deletion, seq(oBracket, concatenates, cBracket)));
        arguments.set(seq(oParen, concatenates, zeroOrMore(seq(comma, concatenates)), cParen));
        indirect.set(seq(oBrace, concatenates, cBrace, arguments));
        direct.set(A(local, seq(untrimmedToken(identifier), optional(arguments))));
        argumentsAndParameters.set(seq(untrimmedToken(oParen), seq(local, untrimmedToken(arrow), concatenates, zeroOrMore(seq(untrimmedToken(comma), local, untrimmedToken(arrow), concatenates))), untrimmedToken(cParen)));

        return switch (type) {
            case "string" -> seq(silent(token(string)), zeroOrMore(any()));
            case "identifier" -> seq(silent(token(identifier)), zeroOrMore(any()));
            case "identifier_with_arguments" ->
                    seq(silent(token(identifier)), silent(token(arguments)), zeroOrMore(any()));
            default -> zeroOrMore(any());
        };
    }
}

