package parser;

import parser.MAID.MAIDCombinators;

import java.util.Arrays;
import java.util.function.Function;

import static parser.MAID.MAIDCombinators.*;

public final class HighOrderCombinators {

    private HighOrderCombinators() {
    }

    public static MAIDCombinators arb() {
        var foo = new FixedPoint();
        foo.set(A(
                I(),
                M(any(), c -> M(foo, rest -> I(c + rest)))
        ));
        return foo;
    }

    public static MAIDCombinators any(final String chars) {
        return D(c -> chars.indexOf(c) >= 0);
    }

    public static MAIDCombinators any() {
        return D(_ -> true);
    }

    public static MAIDCombinators notAny(final String chars) {
        return D(c -> chars.indexOf(c) < 0);
    }

    public static MAIDCombinators literal(final String literal) {
        if (literal.isEmpty()) return I();
        final var parsers = new MAIDCombinators[literal.length()];
        for (var i = 0; i < literal.length(); i++) {
            int finalI = i;
            parsers[i] = D(c -> c == literal.charAt(finalI));
        }
        return seq(parsers);
    }

    public static MAIDCombinators zeroOrMore(final MAIDCombinators p) {
        final var f = new FixedPoint();
        f.set(A(seq(p, f), I()));
        return f;
    }

    public static MAIDCombinators apply(final MAIDCombinators parser, final Function<String, String> f) {
        return M(parser, result -> I(f.apply(result)));
    }

    public static MAIDCombinators seq(final MAIDCombinators... parsers) {
        if (parsers.length == 0)
            return I();
        if (parsers.length == 1)
            return parsers[0];
        return M(parsers[0], result1 ->
                M(seq(Arrays.copyOfRange(parsers, 1, parsers.length)), resultRest ->
                        I(result1 + resultRest)));
    }

    static MAIDCombinators swap(final MAIDCombinators p1, final MAIDCombinators p2) {
        return M(p1, result1 ->
                M(p2, result2 ->
                        I(result2 + result1)));
    }

    public static MAIDCombinators len(int n) {
        if (n <= 0)
            return I();
        else
            return M(D(c -> true),
                    first -> M(len(n - 1),
                            rest -> I(first + rest)));
    }

    public static MAIDCombinators rem() {
        return zeroOrMore(any());
    }

    public static MAIDCombinators oneOrMore(final MAIDCombinators p) {
        return seq(p, zeroOrMore(p));
    }

    public static MAIDCombinators silent(MAIDCombinators combinator) {
        return apply(combinator, _ -> "");
    }

    public static MAIDCombinators optional(MAIDCombinators combinator) {
        return A(combinator, I());
    }

    public static MAIDCombinators optionalWithDefault(MAIDCombinators combinator, String defaultValue) {
        return A(combinator, I(defaultValue));
    }

    public static MAIDCombinators repeat(final MAIDCombinators parser, final int times, final String separator) {
        return apply(parser, matched -> {
            // If times <= 0, produce an empty result
            if (times <= 0) {
                return "";
            }
            // Build repeated text purely via concatenation
            String repeated = "";
            for (int i = 0; i < times; i++) {
                if (i > 0) {
                    repeated += separator;
                }
                repeated += matched;
            }
            return repeated;
        });
    }

    public static MAIDCombinators endsWith(MAIDCombinators parser) {
        return state -> {
            Result res = parser.transform(state);
            if (res instanceof Success s) {
                // If parser succeeded, check if we're at the end.
                State newState = s.state();
                if (newState.pos() == newState.input().length()) {
                    return s;  // Return the same success if the input is fully consumed
                }
                return new Failure("Expected end of input but found more characters", newState);
            }
            // If parser failed, propagate the same failure
            return res;
        };
    }

    /**
     * Alternation over an array of parsers. Kept public for pattern building.
     */
    public static MAIDCombinators alt(MAIDCombinators... ps) {
        return A(ps);
    }
}

